(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["Drawflow"] = factory();
	else
		root["Drawflow"] = factory();
})((typeof self !== 'undefined' ? self : this), function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./assets_src/backend/js/multistep.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./assets_src/backend/js/multistep.js":
/*!********************************************!*\
  !*** ./assets_src/backend/js/multistep.js ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Drawflow; });\nclass Drawflow {\n\tconstructor(container, render = null, parent = null) {\n\t  this.events = {};\n\t  this.container = container;\n\t  this.precanvas = null;\n\t  this.nodeId = 1;\n\t  this.ele_selected = null;\n\t  this.node_selected = null;\n\t  this.drag = false;\n\t  this.reroute = false;\n\t  this.reroute_fix_curvature = false;\n\t  this.curvature = 0.5;\n\t  this.reroute_curvature_start_end = 0.5;\n\t  this.reroute_curvature = 0.5;\n\t  this.reroute_width = 6;\n\t  this.drag_point = false;\n\t  this.editor_selected = false;\n\t  this.connection = false;\n\t  this.connection_ele = null;\n\t  this.connection_selected = null;\n\t  this.canvas_x = 0;\n\t  this.canvas_y = 0;\n\t  this.pos_x = 0;\n\t  this.pos_x_start = 0;\n\t  this.pos_y = 0;\n\t  this.pos_y_start = 0;\n\t  this.mouse_x = 0;\n\t  this.mouse_y = 0;\n\t  this.line_path = 5;\n\t  this.first_click = null;\n\t  this.force_first_input = false;\n\t  this.draggable_inputs = true;\n\t  this.useuuid = false;\n\t  this.parent = parent;\n  \n\t  this.noderegister = {};\n\t  this.render = render;\n\t  this.drawflow = { \"drawflow\": { \"Home\": { \"data\": {} }}};\n\t  // Configurable options\n\t  this.module = 'Home';\n\t  this.editor_mode = 'edit';\n\t  this.zoom = 1;\n\t  this.zoom_max = 1.6;\n\t  this.zoom_min = 0.5;\n\t  this.zoom_value = 0.1;\n\t  this.zoom_last_value = 1;\n  \n\t  // Mobile\n\t  this.evCache = new Array();\n\t  this.prevDiff = -1;\n\t}\n  \n\tstart () {\n\t  // console.info(\"Start Drawflow!!\");\n\t  this.container.classList.add(\"parent-drawflow\");\n\t  this.container.tabIndex = 0;\n\t  this.precanvas = document.createElement('div');\n\t  this.precanvas.classList.add(\"drawflow\");\n\t  this.container.appendChild(this.precanvas);\n  \n\t  /* Mouse and Touch Actions */\n\t  this.container.addEventListener('mouseup', this.dragEnd.bind(this));\n\t  this.container.addEventListener('mousemove', this.position.bind(this));\n\t  this.container.addEventListener('mousedown', this.click.bind(this) );\n  \n\t  this.container.addEventListener('touchend', this.dragEnd.bind(this));\n\t  this.container.addEventListener('touchmove', this.position.bind(this));\n\t  this.container.addEventListener('touchstart', this.click.bind(this));\n  \n\t  /* Context Menu */\n\t  this.container.addEventListener('contextmenu', this.contextmenu.bind(this));\n\t  /* Delete */\n\t  this.container.addEventListener('keydown', this.key.bind(this));\n  \n\t  /* Zoom Mouse */\n\t  this.container.addEventListener('wheel', this.zoom_enter.bind(this));\n\t  /* Update data Nodes */\n\t  this.container.addEventListener('input', this.updateNodeValue.bind(this));\n  \n\t  this.container.addEventListener('dblclick', this.dblclick.bind(this));\n\t  /* Mobile zoom */\n\t  this.container.onpointerdown = this.pointerdown_handler.bind(this);\n\t  this.container.onpointermove = this.pointermove_handler.bind(this);\n\t  this.container.onpointerup = this.pointerup_handler.bind(this);\n\t  this.container.onpointercancel = this.pointerup_handler.bind(this);\n\t  this.container.onpointerout = this.pointerup_handler.bind(this);\n\t  this.container.onpointerleave = this.pointerup_handler.bind(this);\n  \n\t  this.load();\n\t}\n  \n\t/* Mobile zoom */\n\tpointerdown_handler(ev) {\n\t this.evCache.push(ev);\n\t}\n  \n\tpointermove_handler(ev) {\n\t for (var i = 0; i < this.evCache.length; i++) {\n\t   if (ev.pointerId == this.evCache[i].pointerId) {\n\t\t  this.evCache[i] = ev;\n\t   break;\n\t   }\n\t }\n  \n\t if (this.evCache.length == 2) {\n\t   // Calculate the distance between the two pointers\n\t   var curDiff = Math.abs(this.evCache[0].clientX - this.evCache[1].clientX);\n  \n\t   if (this.prevDiff > 100) {\n\t\t if (curDiff > this.prevDiff) {\n\t\t   // The distance between the two pointers has increased\n  \n\t\t   this.zoom_in();\n\t\t }\n\t\t if (curDiff < this.prevDiff) {\n\t\t   // The distance between the two pointers has decreased\n\t\t   this.zoom_out();\n\t\t }\n\t   }\n\t   this.prevDiff = curDiff;\n\t }\n\t}\n  \n\tpointerup_handler(ev) {\n\t  this.remove_event(ev);\n\t  if (this.evCache.length < 2) {\n\t\tthis.prevDiff = -1;\n\t  }\n\t}\n\tremove_event(ev) {\n\t // Remove this event from the target's cache\n\t for (var i = 0; i < this.evCache.length; i++) {\n\t   if (this.evCache[i].pointerId == ev.pointerId) {\n\t\t this.evCache.splice(i, 1);\n\t\t break;\n\t   }\n\t }\n\t}\n\t/* End Mobile Zoom */\n\tload() {\n\t  for (var key in this.drawflow.drawflow[this.module].data) {\n\t\tthis.addNodeImport(this.drawflow.drawflow[this.module].data[key], this.precanvas);\n\t  }\n  \n\t  if(this.reroute) {\n\t\tfor (var key in this.drawflow.drawflow[this.module].data) {\n\t\t  this.addRerouteImport(this.drawflow.drawflow[this.module].data[key]);\n\t\t}\n\t  }\n  \n\t  for (var key in this.drawflow.drawflow[this.module].data) {\n\t\tthis.updateConnectionNodes('node-'+key);\n\t  }\n  \n\t  const editor = this.drawflow.drawflow;\n\t  let number = 1;\n\t  Object.keys(editor).map(function(moduleName, index) {\n\t\tObject.keys(editor[moduleName].data).map(function(id, index2) {\n\t\t  if(parseInt(id) >= number) {\n\t\t\tnumber = parseInt(id)+1;\n\t\t  }\n\t\t});\n\t  });\n\t  this.nodeId = number;\n\t}\n  \n\tremoveReouteConnectionSelected(){\n\t  this.dispatch('connectionUnselected', true);\n\t  if(this.reroute_fix_curvature) {\n\t\tthis.connection_selected.parentElement.querySelectorAll(\".main-path\").forEach((item, i) => {\n\t\t  item.classList.remove(\"selected\");\n\t\t});\n\t  }\n\t}\n  \n\tclick(e) {\n\t  this.dispatch('click', e);\n\t  if(this.editor_mode === 'fixed') {\n\t\t//return false;\n\t\t e.preventDefault();\n\t\t if(e.target.classList[0] === 'parent-drawflow' || e.target.classList[0] === 'drawflow') {\n\t\t   this.ele_selected = e.target.closest(\".parent-drawflow\");\n\t\t } else {\n\t\t   return false;\n\t\t }\n\t  } else if(this.editor_mode === 'view') {\n\t\tif(e.target.closest(\".drawflow\") != null || e.target.matches('.parent-drawflow')) {\n\t\t  this.ele_selected = e.target.closest(\".parent-drawflow\");\n\t\t  e.preventDefault();\n\t\t}\n\t  } else {\n\t\tthis.first_click = e.target;\n\t\tthis.ele_selected = e.target;\n\t\tif(e.button === 0) {\n\t\t  this.contextmenuDel();\n\t\t}\n  \n\t\tif(e.target.closest(\".drawflow_content_node\") != null) {\n\t\t  this.ele_selected = e.target.closest(\".drawflow_content_node\").parentElement;\n\t\t}\n\t  }\n\t  switch (this.ele_selected.classList[0]) {\n\t\tcase 'drawflow-node':\n\t\t  if(this.node_selected != null) {\n\t\t\tthis.node_selected.classList.remove(\"selected\");\n\t\t\tif(this.node_selected != this.ele_selected) {\n\t\t\t  this.dispatch('nodeUnselected', true);\n\t\t\t}\n\t\t  }\n\t\t  if(this.connection_selected != null) {\n\t\t\tthis.connection_selected.classList.remove(\"selected\");\n\t\t\tthis.removeReouteConnectionSelected();\n\t\t\tthis.connection_selected = null;\n\t\t  }\n\t\t  if(this.node_selected != this.ele_selected) {\n\t\t\tthis.dispatch('nodeSelected', this.ele_selected.id.slice(5));\n\t\t  }\n\t\t  this.node_selected = this.ele_selected;\n\t\t  this.node_selected.classList.add(\"selected\");\n\t\t  if(!this.draggable_inputs) {\n\t\t\tif(e.target.tagName !== 'INPUT' && e.target.tagName !== 'TEXTAREA' && e.target.tagName !== 'SELECT' && e.target.hasAttribute('contenteditable') !== true) {\n\t\t\t  this.drag = true;\n\t\t\t}\n\t\t  } else {\n\t\t\tif(e.target.tagName !== 'SELECT') {\n\t\t\t  this.drag = true;\n\t\t\t}\n\t\t  }\n\t\t  break;\n\t\tcase 'output':\n\t\t  this.connection = true;\n\t\t  if(this.node_selected != null) {\n\t\t\tthis.node_selected.classList.remove(\"selected\");\n\t\t\tthis.node_selected = null;\n\t\t\tthis.dispatch('nodeUnselected', true);\n\t\t  }\n\t\t  if(this.connection_selected != null) {\n\t\t\tthis.connection_selected.classList.remove(\"selected\");\n\t\t\tthis.removeReouteConnectionSelected();\n\t\t\tthis.connection_selected = null;\n\t\t  }\n\t\t  this.drawConnection(e.target);\n\t\t  break;\n\t\tcase 'parent-drawflow':\n\t\t  if(this.node_selected != null) {\n\t\t\tthis.node_selected.classList.remove(\"selected\");\n\t\t\tthis.node_selected = null;\n\t\t\tthis.dispatch('nodeUnselected', true);\n\t\t  }\n\t\t  if(this.connection_selected != null) {\n\t\t\tthis.connection_selected.classList.remove(\"selected\");\n\t\t\tthis.removeReouteConnectionSelected();\n\t\t\tthis.connection_selected = null;\n\t\t  }\n\t\t  this.editor_selected = true;\n\t\t  break;\n\t\tcase 'drawflow':\n\t\t  if(this.node_selected != null) {\n\t\t\tthis.node_selected.classList.remove(\"selected\");\n\t\t\tthis.node_selected = null;\n\t\t\tthis.dispatch('nodeUnselected', true);\n\t\t  }\n\t\t  if(this.connection_selected != null) {\n\t\t\tthis.connection_selected.classList.remove(\"selected\");\n\t\t\tthis.removeReouteConnectionSelected();\n\t\t\tthis.connection_selected = null;\n\t\t  }\n\t\t  this.editor_selected = true;\n\t\t  break;\n\t\tcase 'main-path':\n\t\t  if(this.node_selected != null) {\n\t\t\tthis.node_selected.classList.remove(\"selected\");\n\t\t\tthis.node_selected = null;\n\t\t\tthis.dispatch('nodeUnselected', true);\n\t\t  }\n\t\t  if(this.connection_selected != null) {\n\t\t\tthis.connection_selected.classList.remove(\"selected\");\n\t\t\tthis.removeReouteConnectionSelected();\n\t\t\tthis.connection_selected = null;\n\t\t  }\n\t\t  this.connection_selected = this.ele_selected;\n\t\t  this.connection_selected.classList.add(\"selected\");\n\t\t  const listclassConnection = this.connection_selected.parentElement.classList;\n\t\t  if(listclassConnection.length > 1){\n\t\t\tthis.dispatch('connectionSelected', { output_id: listclassConnection[2].slice(14), input_id: listclassConnection[1].slice(13), output_class: listclassConnection[3], input_class: listclassConnection[4] });\n\t\t\tif(this.reroute_fix_curvature) {\n\t\t\t  this.connection_selected.parentElement.querySelectorAll(\".main-path\").forEach((item, i) => {\n\t\t\t\titem.classList.add(\"selected\");\n\t\t\t  });\n\t\t\t}\n\t\t  }\n\t\tbreak;\n\t\tcase 'point':\n\t\t  this.drag_point = true;\n\t\t  this.ele_selected.classList.add(\"selected\");\n\t\tbreak;\n\t\tcase 'drawflow-delete':\n\t\t  if(this.node_selected ) {\n\t\t\tthis.removeNodeId(this.node_selected.id);\n\t\t  }\n  \n\t\t  if(this.connection_selected) {\n\t\t\tthis.removeConnection();\n\t\t  }\n  \n\t\t  if(this.node_selected != null) {\n\t\t\tthis.node_selected.classList.remove(\"selected\");\n\t\t\tthis.node_selected = null;\n\t\t\tthis.dispatch('nodeUnselected', true);\n\t\t  }\n\t\t  if(this.connection_selected != null) {\n\t\t\tthis.connection_selected.classList.remove(\"selected\");\n\t\t\tthis.removeReouteConnectionSelected();\n\t\t\tthis.connection_selected = null;\n\t\t  }\n  \n\t\tbreak;\n\t\tdefault:\n\t  }\n\t  if (e.type === \"touchstart\") {\n\t\tthis.pos_x = e.touches[0].clientX;\n\t\tthis.pos_x_start = e.touches[0].clientX;\n\t\tthis.pos_y = e.touches[0].clientY;\n\t\tthis.pos_y_start = e.touches[0].clientY;\n\t\tthis.mouse_x = e.touches[0].clientX;\n\t\tthis.mouse_y = e.touches[0].clientY;\n\t  } else {\n\t\tthis.pos_x = e.clientX;\n\t\tthis.pos_x_start = e.clientX;\n\t\tthis.pos_y = e.clientY;\n\t\tthis.pos_y_start = e.clientY;\n\t  }\n\t  if (['input','output','main-path'].includes(this.ele_selected.classList[0])) {\n\t\te.preventDefault();\n\t  }\n\t  this.dispatch('clickEnd', e);\n\t}\n  \n\tposition(e) {\n\t  if (e.type === \"touchmove\") {\n\t\tvar e_pos_x = e.touches[0].clientX;\n\t\tvar e_pos_y = e.touches[0].clientY;\n\t  } else {\n\t\tvar e_pos_x = e.clientX;\n\t\tvar e_pos_y = e.clientY;\n\t  }\n  \n  \n\t  if(this.connection) {\n\t\tthis.updateConnection(e_pos_x, e_pos_y);\n\t  }\n\t  if(this.editor_selected) {\n\t\tx =  this.canvas_x + (-(this.pos_x - e_pos_x))\n\t\ty = this.canvas_y + (-(this.pos_y - e_pos_y))\n\t\tthis.dispatch('translate', { x: x, y: y});\n\t\tthis.precanvas.style.transform = \"translate(\"+x+\"px, \"+y+\"px) scale(\"+this.zoom+\")\";\n\t  }\n\t  if(this.drag) {\n\t\te.preventDefault();\n\t\tvar x = (this.pos_x - e_pos_x) * this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom);\n\t\tvar y = (this.pos_y - e_pos_y) * this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom);\n\t\tthis.pos_x = e_pos_x;\n\t\tthis.pos_y = e_pos_y;\n  \n\t\tthis.ele_selected.style.top = (this.ele_selected.offsetTop - y) + \"px\";\n\t\tthis.ele_selected.style.left = (this.ele_selected.offsetLeft - x) + \"px\";\n  \n\t\tthis.drawflow.drawflow[this.module].data[this.ele_selected.id.slice(5)].pos_x = (this.ele_selected.offsetLeft - x);\n\t\tthis.drawflow.drawflow[this.module].data[this.ele_selected.id.slice(5)].pos_y = (this.ele_selected.offsetTop - y);\n  \n\t\tthis.updateConnectionNodes(this.ele_selected.id)\n\t  }\n  \n\t  if(this.drag_point) {\n  \n\t\tvar x = (this.pos_x - e_pos_x) * this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom);\n\t\tvar y = (this.pos_y - e_pos_y) * this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom);\n\t\tthis.pos_x = e_pos_x;\n\t\tthis.pos_y = e_pos_y;\n  \n\t\tvar pos_x = this.pos_x * ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)) - (this.precanvas.getBoundingClientRect().x * ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)));\n\t\tvar pos_y = this.pos_y * ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)) - (this.precanvas.getBoundingClientRect().y * ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)));\n  \n\t\tthis.ele_selected.setAttributeNS(null, 'cx', pos_x);\n\t\tthis.ele_selected.setAttributeNS(null, 'cy', pos_y);\n  \n\t\tconst nodeUpdate = this.ele_selected.parentElement.classList[2].slice(9);\n\t\tconst nodeUpdateIn = this.ele_selected.parentElement.classList[1].slice(13);\n\t\tconst output_class = this.ele_selected.parentElement.classList[3];\n\t\tconst input_class = this.ele_selected.parentElement.classList[4];\n  \n\t\tlet numberPointPosition = Array.from(this.ele_selected.parentElement.children).indexOf(this.ele_selected)-1;\n  \n\t\tif(this.reroute_fix_curvature) {\n\t\t  const numberMainPath = this.ele_selected.parentElement.querySelectorAll(\".main-path\").length-1;\n\t\t  numberPointPosition -= numberMainPath;\n\t\t  if(numberPointPosition < 0) {\n\t\t\tnumberPointPosition = 0;\n\t\t  }\n\t\t}\n  \n\t\tconst nodeId = nodeUpdate.slice(5);\n\t\tconst searchConnection = this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections.findIndex(function(item,i) {\n\t\t  return item.node ===  nodeUpdateIn && item.output === input_class;\n\t\t});\n  \n\t\tthis.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points[numberPointPosition] = { pos_x: pos_x, pos_y: pos_y };\n  \n\t\tconst parentSelected = this.ele_selected.parentElement.classList[2].slice(9);\n  \n\t\tthis.updateConnectionNodes(parentSelected);\n\t  }\n  \n\t  if (e.type === \"touchmove\") {\n\t\tthis.mouse_x = e_pos_x;\n\t\tthis.mouse_y = e_pos_y;\n\t  }\n\t  this.dispatch('mouseMove', {x: e_pos_x,y: e_pos_y });\n\t}\n  \n\tdragEnd(e) {\n\t  if (e.type === \"touchend\") {\n\t\tvar e_pos_x = this.mouse_x;\n\t\tvar e_pos_y = this.mouse_y;\n\t\tvar ele_last = document.elementFromPoint(e_pos_x, e_pos_y);\n\t  } else {\n\t\tvar e_pos_x = e.clientX;\n\t\tvar e_pos_y = e.clientY;\n\t\tvar ele_last = e.target;\n\t  }\n  \n\t  if(this.drag) {\n\t\tif(this.pos_x_start != e_pos_x || this.pos_y_start != e_pos_y) {\n\t\t  this.dispatch('nodeMoved', this.ele_selected.id.slice(5));\n\t\t}\n\t  }\n  \n\t  if(this.drag_point) {\n\t\tthis.ele_selected.classList.remove(\"selected\");\n\t\t  if(this.pos_x_start != e_pos_x || this.pos_y_start != e_pos_y) {\n\t\t\tthis.dispatch('rerouteMoved', this.ele_selected.parentElement.classList[2].slice(14));\n\t\t  }\n\t  }\n  \n\t  if(this.editor_selected) {\n\t\tthis.canvas_x = this.canvas_x + (-(this.pos_x - e_pos_x));\n\t\tthis.canvas_y = this.canvas_y + (-(this.pos_y - e_pos_y));\n\t\tthis.editor_selected = false;\n\t  }\n\t  if(this.connection === true) {\n\t\tif(ele_last.classList[0] === 'input' || (this.force_first_input && (ele_last.closest(\".drawflow_content_node\") != null || ele_last.classList[0] === 'drawflow-node'))) {\n  \n\t\t  if(this.force_first_input && (ele_last.closest(\".drawflow_content_node\") != null || ele_last.classList[0] === 'drawflow-node')) {\n\t\t\tif(ele_last.closest(\".drawflow_content_node\") != null) {\n\t\t\t  var input_id = ele_last.closest(\".drawflow_content_node\").parentElement.id;\n\t\t\t} else {\n\t\t\t  var input_id = ele_last.id;\n\t\t\t}\n\t\t   if(Object.keys(this.getNodeFromId(input_id.slice(5)).inputs).length === 0) {\n\t\t\t var input_class = false;\n\t\t   } else {\n\t\t\tvar input_class = \"input_1\";\n\t\t   }\n  \n  \n\t\t } else {\n\t\t   // Fix connection;\n\t\t   var input_id = ele_last.parentElement.parentElement.id;\n\t\t   var input_class = ele_last.classList[1];\n\t\t }\n\t\t var output_id = this.ele_selected.parentElement.parentElement.id;\n\t\t var output_class = this.ele_selected.classList[1];\n  \n\t\t  if(output_id !== input_id && input_class !== false) {\n  \n\t\t\tif(this.container.querySelectorAll('.connection.node_in_'+input_id+'.node_out_'+output_id+'.'+output_class+'.'+input_class).length === 0) {\n\t\t\t// Conection no exist save connection\n  \n\t\t\tthis.connection_ele.classList.add(\"node_in_\"+input_id);\n\t\t\tthis.connection_ele.classList.add(\"node_out_\"+output_id);\n\t\t\tthis.connection_ele.classList.add(output_class);\n\t\t\tthis.connection_ele.classList.add(input_class);\n\t\t\tvar id_input = input_id.slice(5);\n\t\t\tvar id_output = output_id.slice(5);\n  \n\t\t\tthis.drawflow.drawflow[this.module].data[id_output].outputs[output_class].connections.push( {\"node\": id_input, \"output\": input_class});\n\t\t\tthis.drawflow.drawflow[this.module].data[id_input].inputs[input_class].connections.push( {\"node\": id_output, \"input\": output_class});\n\t\t\tthis.updateConnectionNodes('node-'+id_output);\n\t\t\tthis.updateConnectionNodes('node-'+id_input);\n\t\t\tthis.dispatch('connectionCreated', { output_id: id_output, input_id: id_input, output_class:  output_class, input_class: input_class});\n  \n\t\t  } else {\n\t\t\tthis.dispatch('connectionCancel', true);\n\t\t\tthis.connection_ele.remove();\n\t\t  }\n  \n\t\t\tthis.connection_ele = null;\n\t\t} else {\n\t\t  // Connection exists Remove Connection;\n\t\t  this.dispatch('connectionCancel', true);\n\t\t  this.connection_ele.remove();\n\t\t  this.connection_ele = null;\n\t\t}\n  \n\t\t} else {\n\t\t  // Remove Connection;\n\t\t  this.dispatch('connectionCancel', true);\n\t\t  this.connection_ele.remove();\n\t\t  this.connection_ele = null;\n\t\t}\n\t  }\n  \n\t  this.drag = false;\n\t  this.drag_point = false;\n\t  this.connection = false;\n\t  this.ele_selected = null;\n\t  this.editor_selected = false;\n  \n\t  this.dispatch('mouseUp', e);\n\t}\n\tcontextmenu(e) {\n\t  this.dispatch('contextmenu', e);\n\t  e.preventDefault();\n\t  if(this.editor_mode === 'fixed' || this.editor_mode === 'view') {\n\t\treturn false;\n\t  }\n\t  if(this.precanvas.getElementsByClassName(\"drawflow-delete\").length) {\n\t\tthis.precanvas.getElementsByClassName(\"drawflow-delete\")[0].remove()\n\t  };\n\t  if(this.node_selected || this.connection_selected) {\n\t\tvar deletebox = document.createElement('div');\n\t\tdeletebox.classList.add(\"drawflow-delete\");\n\t\tdeletebox.innerHTML = \"x\";\n\t\tif(this.node_selected) {\n\t\t  this.node_selected.appendChild(deletebox);\n  \n\t\t}\n\t\tif(this.connection_selected && (this.connection_selected.parentElement.classList.length > 1)) {\n\t\t  deletebox.style.top = e.clientY * ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)) - (this.precanvas.getBoundingClientRect().y *  ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)) ) + \"px\";\n\t\t  deletebox.style.left = e.clientX * ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)) - (this.precanvas.getBoundingClientRect().x *  ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)) ) + \"px\";\n  \n\t\t  this.precanvas.appendChild(deletebox);\n  \n\t\t}\n  \n\t  }\n  \n\t}\n\tcontextmenuDel() {\n\t  if(this.precanvas.getElementsByClassName(\"drawflow-delete\").length) {\n\t\tthis.precanvas.getElementsByClassName(\"drawflow-delete\")[0].remove()\n\t  };\n\t}\n  \n\tkey(e) {\n\t  this.dispatch('keydown', e);\n\t  if(this.editor_mode === 'fixed' || this.editor_mode === 'view') {\n\t\treturn false;\n\t  }\n\t  if (e.key === 'Delete' || (e.key === 'Backspace' && e.metaKey)) {\n\t\tif(this.node_selected != null) {\n\t\t  if(this.first_click.tagName !== 'INPUT' && this.first_click.tagName !== 'TEXTAREA' && this.first_click.hasAttribute('contenteditable') !== true) {\n\t\t\tthis.removeNodeId(this.node_selected.id);\n\t\t  }\n\t\t}\n\t\tif(this.connection_selected != null) {\n\t\t  this.removeConnection();\n\t\t}\n\t  }\n\t}\n  \n\tzoom_enter(event, delta) {\n\t  if (event.ctrlKey) {\n\t\tevent.preventDefault()\n\t\tif(event.deltaY > 0) {\n\t\t  // Zoom Out\n\t\t  this.zoom_out();\n\t\t} else {\n\t\t  // Zoom In\n\t\t  this.zoom_in();\n\t\t}\n\t  }\n\t}\n\tzoom_refresh(){\n\t  this.dispatch('zoom', this.zoom);\n\t  this.canvas_x = (this.canvas_x / this.zoom_last_value) * this.zoom;\n\t  this.canvas_y = (this.canvas_y / this.zoom_last_value) * this.zoom;\n\t  this.zoom_last_value = this.zoom;\n\t  this.precanvas.style.transform = \"translate(\"+this.canvas_x+\"px, \"+this.canvas_y+\"px) scale(\"+this.zoom+\")\";\n\t}\n\tzoom_in() {\n\t  if(this.zoom < this.zoom_max) {\n\t\t  this.zoom+=this.zoom_value;\n\t\t  this.zoom_refresh();\n\t  }\n\t}\n\tzoom_out() {\n\t  if(this.zoom > this.zoom_min) {\n\t\tthis.zoom-=this.zoom_value;\n\t\t  this.zoom_refresh();\n\t  }\n\t}\n\tzoom_reset(){\n\t  if(this.zoom != 1) {\n\t\tthis.zoom = 1;\n\t\tthis.zoom_refresh();\n\t  }\n\t}\n  \n\tcreateCurvature(start_pos_x, start_pos_y, end_pos_x, end_pos_y, curvature_value, type) {\n\t  var line_x = start_pos_x;\n\t  var line_y = start_pos_y;\n\t  var x = end_pos_x;\n\t  var y = end_pos_y;\n\t  var curvature = curvature_value;\n\t  //type openclose open close other\n\t  switch (type) {\n\t\tcase 'open':\n\t\t  if(start_pos_x >= end_pos_x) {\n\t\t\tvar hx1 = line_x + Math.abs(x - line_x) * curvature;\n\t\t\tvar hx2 = x - Math.abs(x - line_x) * (curvature*-1);\n\t\t  } else {\n\t\t\tvar hx1 = line_x + Math.abs(x - line_x) * curvature;\n\t\t\tvar hx2 = x - Math.abs(x - line_x) * curvature;\n\t\t  }\n\t\t  return ' M '+ line_x +' '+ line_y +' C '+ hx1 +' '+ line_y +' '+ hx2 +' ' + y +' ' + x +'  ' + y;\n  \n\t\t  break\n\t\tcase 'close':\n\t\t  if(start_pos_x >= end_pos_x) {\n\t\t\tvar hx1 = line_x + Math.abs(x - line_x) * (curvature*-1);\n\t\t\tvar hx2 = x - Math.abs(x - line_x) * curvature;\n\t\t  } else {\n\t\t\tvar hx1 = line_x + Math.abs(x - line_x) * curvature;\n\t\t\tvar hx2 = x - Math.abs(x - line_x) * curvature;\n\t\t  }\n\t\t  return ' M '+ line_x +' '+ line_y +' C '+ hx1 +' '+ line_y +' '+ hx2 +' ' + y +' ' + x +'  ' + y;\n\t\t  break;\n\t\tcase 'other':\n\t\t  if(start_pos_x >= end_pos_x) {\n\t\t\tvar hx1 = line_x + Math.abs(x - line_x) * (curvature*-1);\n\t\t\tvar hx2 = x - Math.abs(x - line_x) * (curvature*-1);\n\t\t  } else {\n\t\t\tvar hx1 = line_x + Math.abs(x - line_x) * curvature;\n\t\t\tvar hx2 = x - Math.abs(x - line_x) * curvature;\n\t\t  }\n\t\t  return ' M '+ line_x +' '+ line_y +' C '+ hx1 +' '+ line_y +' '+ hx2 +' ' + y +' ' + x +'  ' + y;\n\t\t  break;\n\t\tdefault:\n  \n\t\t  var hx1 = line_x + Math.abs(x - line_x) * curvature;\n\t\t  var hx2 = x - Math.abs(x - line_x) * curvature;\n  \n\t\t  return ' M '+ line_x +' '+ line_y +' C '+ hx1 +' '+ line_y +' '+ hx2 +' ' + y +' ' + x +'  ' + y;\n\t  }\n  \n\t}\n  \n\tdrawConnection(ele) {\n\t  var connection = document.createElementNS('http://www.w3.org/2000/svg',\"svg\");\n\t  this.connection_ele = connection;\n\t  var path = document.createElementNS('http://www.w3.org/2000/svg',\"path\");\n\t  path.classList.add(\"main-path\");\n\t  path.setAttributeNS(null, 'd', '');\n\t  // path.innerHTML = 'a';\n\t  connection.classList.add(\"connection\");\n\t  connection.appendChild(path);\n\t  this.precanvas.appendChild(connection);\n\t  var id_output = ele.parentElement.parentElement.id.slice(5);\n\t  var output_class = ele.classList[1];\n\t  this.dispatch('connectionStart', { output_id: id_output, output_class:  output_class });\n  \n\t}\n  \n\tupdateConnection(eX, eY) {\n\t  const precanvas = this.precanvas;\n\t  const zoom = this.zoom;\n\t  let precanvasWitdhZoom = precanvas.clientWidth / (precanvas.clientWidth * zoom);\n\t  precanvasWitdhZoom = precanvasWitdhZoom || 0;\n\t  let precanvasHeightZoom = precanvas.clientHeight / (precanvas.clientHeight * zoom);\n\t  precanvasHeightZoom = precanvasHeightZoom || 0;\n\t  var path = this.connection_ele.children[0];\n  \n\t  var line_x = this.ele_selected.offsetWidth/2 + (this.ele_selected.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t  var line_y = this.ele_selected.offsetHeight/2 + (this.ele_selected.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t  var x = eX * ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)) - (this.precanvas.getBoundingClientRect().x *  ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)) );\n\t  var y = eY * ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)) - (this.precanvas.getBoundingClientRect().y *  ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)) );\n  \n\t  var curvature = this.curvature;\n\t  var lineCurve = this.createCurvature(line_x, line_y, x, y, curvature, 'openclose');\n\t  path.setAttributeNS(null, 'd', lineCurve);\n  \n\t}\n  \n\taddConnection(id_output, id_input, output_class, input_class) {\n\t  var nodeOneModule = this.getModuleFromNodeId(id_output);\n\t  var nodeTwoModule = this.getModuleFromNodeId(id_input);\n\t  if(nodeOneModule === nodeTwoModule) {\n  \n\t\tvar dataNode = this.getNodeFromId(id_output);\n\t\tvar exist = false;\n\t\tfor(var checkOutput in dataNode.outputs[output_class].connections){\n\t\t  var connectionSearch = dataNode.outputs[output_class].connections[checkOutput]\n\t\t  if(connectionSearch.node == id_input && connectionSearch.output == input_class) {\n\t\t\t  exist = true;\n\t\t  }\n\t\t}\n\t\t// Check connection exist\n\t\tif(exist === false) {\n\t\t  //Create Connection\n\t\t  this.drawflow.drawflow[nodeOneModule].data[id_output].outputs[output_class].connections.push( {\"node\": id_input.toString(), \"output\": input_class});\n\t\t  this.drawflow.drawflow[nodeOneModule].data[id_input].inputs[input_class].connections.push( {\"node\": id_output.toString(), \"input\": output_class});\n  \n\t\t  if(this.module === nodeOneModule) {\n\t\t  //Draw connection\n\t\t\tvar connection = document.createElementNS('http://www.w3.org/2000/svg',\"svg\");\n\t\t\tvar path = document.createElementNS('http://www.w3.org/2000/svg',\"path\");\n\t\t\tpath.classList.add(\"main-path\");\n\t\t\tpath.setAttributeNS(null, 'd', '');\n\t\t\t// path.innerHTML = 'a';\n\t\t\tconnection.classList.add(\"connection\");\n\t\t\tconnection.classList.add(\"node_in_node-\"+id_input);\n\t\t\tconnection.classList.add(\"node_out_node-\"+id_output);\n\t\t\tconnection.classList.add(output_class);\n\t\t\tconnection.classList.add(input_class);\n\t\t\tconnection.appendChild(path);\n\t\t\tthis.precanvas.appendChild(connection);\n\t\t\tthis.updateConnectionNodes('node-'+id_output);\n\t\t\tthis.updateConnectionNodes('node-'+id_input);\n\t\t  }\n  \n\t\t  this.dispatch('connectionCreated', { output_id: id_output, input_id: id_input, output_class:  output_class, input_class: input_class});\n\t\t}\n\t  }\n\t}\n  \n\tupdateConnectionNodes(id) {\n  \n\t  // Aquí nos quedamos;\n\t  const idSearch = 'node_in_'+id;\n\t  const idSearchOut = 'node_out_'+id;\n\t  var line_path = this.line_path/2;\n\t  const container = this.container;\n\t  const precanvas = this.precanvas;\n\t  const curvature = this.curvature;\n\t  const createCurvature = this.createCurvature;\n\t  const reroute_curvature = this.reroute_curvature;\n\t  const reroute_curvature_start_end = this.reroute_curvature_start_end;\n\t  const reroute_fix_curvature = this.reroute_fix_curvature;\n\t  const rerouteWidth = this.reroute_width;\n\t  const zoom = this.zoom;\n\t  let precanvasWitdhZoom = precanvas.clientWidth / (precanvas.clientWidth * zoom);\n\t  precanvasWitdhZoom = precanvasWitdhZoom || 0;\n\t  let precanvasHeightZoom = precanvas.clientHeight / (precanvas.clientHeight * zoom);\n\t  precanvasHeightZoom = precanvasHeightZoom || 0;\n  \n\t  const elemsOut = container.querySelectorAll(`.${idSearchOut}`);\n  \n\t  Object.keys(elemsOut).map(function(item, index) {\n\t\tif(elemsOut[item].querySelector('.point') === null) {\n  \n\t\t  var elemtsearchId_out = container.querySelector(`#${id}`);\n  \n\t\t  var id_search = elemsOut[item].classList[1].replace('node_in_', '');\n\t\t  var elemtsearchId = container.querySelector(`#${id_search}`);\n  \n\t\t  var elemtsearch = elemtsearchId.querySelectorAll('.'+elemsOut[item].classList[4])[0]\n  \n\t\t  var eX = elemtsearch.offsetWidth/2 + (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t  var eY = elemtsearch.offsetHeight/2 + (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t  var elemtsearchOut = elemtsearchId_out.querySelectorAll('.'+elemsOut[item].classList[3])[0]\n  \n\t\t  var line_x =  elemtsearchOut.offsetWidth/2 + (elemtsearchOut.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t  var line_y =  elemtsearchOut.offsetHeight/2 + (elemtsearchOut.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t  var x = eX;\n\t\t  var y = eY;\n  \n\t\t  const lineCurve = createCurvature(line_x, line_y, x, y, curvature, 'openclose');\n\t\t  elemsOut[item].children[0].setAttributeNS(null, 'd', lineCurve );\n\t\t} else {\n\t\t  const points = elemsOut[item].querySelectorAll('.point');\n\t\t  let linecurve = '';\n\t\t  const reoute_fix = [];\n\t\t  points.forEach((item, i) => {\n\t\t\tif(i === 0 && ((points.length -1) === 0)) {\n  \n\t\t\t  var elemtsearchId_out = container.querySelector(`#${id}`);\n\t\t\t  var elemtsearch = item;\n  \n\t\t\t  var eX =  (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var eY =  (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n  \n\t\t\t  var elemtsearchOut = elemtsearchId_out.querySelectorAll('.'+item.parentElement.classList[3])[0]\n\t\t\t  var line_x =  elemtsearchOut.offsetWidth/2 + (elemtsearchOut.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var line_y =  elemtsearchOut.offsetHeight/2 + (elemtsearchOut.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'open');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t  var elemtsearchId_out = item;\n\t\t\t  var id_search = item.parentElement.classList[1].replace('node_in_', '');\n\t\t\t  var elemtsearchId = container.querySelector(`#${id_search}`);\n\t\t\t  var elemtsearch = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[4])[0]\n  \n\t\t\t  var elemtsearchIn = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[4])[0]\n\t\t\t  var eX =  elemtsearchIn.offsetWidth/2 + (elemtsearchIn.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var eY =  elemtsearchIn.offsetHeight/2 + (elemtsearchIn.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n  \n\t\t\t  var line_x = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var line_y = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'close');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t} else if(i === 0) {\n  \n\t\t\t  var elemtsearchId_out = container.querySelector(`#${id}`);\n\t\t\t  var elemtsearch = item;\n  \n\t\t\t  var eX = (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var eY = (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n  \n\t\t\t  var elemtsearchOut = elemtsearchId_out.querySelectorAll('.'+item.parentElement.classList[3])[0]\n\t\t\t  var line_x =  elemtsearchOut.offsetWidth/2 + (elemtsearchOut.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var line_y =  elemtsearchOut.offsetHeight/2 + (elemtsearchOut.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'open');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t  // SECOND\n\t\t\t  var elemtsearchId_out = item;\n\t\t\t  var elemtsearch = points[i+1];\n  \n\t\t\t  var eX = (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var eY = (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var line_x = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var line_y = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature, 'other');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t} else if (i === (points.length -1)) {\n  \n\t\t\t  var elemtsearchId_out = item;\n  \n\t\t\t  var id_search = item.parentElement.classList[1].replace('node_in_', '');\n\t\t\t  var elemtsearchId = container.querySelector(`#${id_search}`);\n\t\t\t  var elemtsearch = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[4])[0]\n  \n\t\t\t  var elemtsearchIn = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[4])[0]\n\t\t\t  var eX =  elemtsearchIn.offsetWidth/2 + (elemtsearchIn.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var eY =  elemtsearchIn.offsetHeight/2 + (elemtsearchIn.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n\t\t\t  var line_x = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * (precanvas.clientWidth / (precanvas.clientWidth * zoom)) + rerouteWidth;\n\t\t\t  var line_y = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * (precanvas.clientHeight / (precanvas.clientHeight * zoom)) + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'close');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t} else {\n\t\t\t  var elemtsearchId_out = item;\n\t\t\t  var elemtsearch = points[i+1];\n  \n\t\t\t  var eX = (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * (precanvas.clientWidth / (precanvas.clientWidth * zoom)) + rerouteWidth;\n\t\t\t  var eY = (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * (precanvas.clientHeight / (precanvas.clientHeight * zoom)) +rerouteWidth;\n\t\t\t  var line_x = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * (precanvas.clientWidth / (precanvas.clientWidth * zoom)) + rerouteWidth;\n\t\t\t  var line_y = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * (precanvas.clientHeight / (precanvas.clientHeight * zoom)) + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature, 'other');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n\t\t\t}\n  \n\t\t  });\n\t\t  if(reroute_fix_curvature) {\n\t\t\treoute_fix.forEach((itempath, i) => {\n\t\t\t  elemsOut[item].children[i].setAttributeNS(null, 'd', itempath);\n\t\t\t});\n  \n\t\t  } else {\n\t\t\telemsOut[item].children[0].setAttributeNS(null, 'd', linecurve);\n\t\t  }\n  \n\t\t}\n\t  })\n  \n\t  const elems = container.querySelectorAll(`.${idSearch}`);\n\t  Object.keys(elems).map(function(item, index) {\n  \n\t\tif(elems[item].querySelector('.point') === null) {\n\t\t  var elemtsearchId_in = container.querySelector(`#${id}`);\n  \n\t\t  var id_search = elems[item].classList[2].replace('node_out_', '');\n\t\t  var elemtsearchId = container.querySelector(`#${id_search}`);\n\t\t  var elemtsearch = elemtsearchId.querySelectorAll('.'+elems[item].classList[3])[0]\n  \n\t\t  var line_x = elemtsearch.offsetWidth/2 + (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t  var line_y = elemtsearch.offsetHeight/2 + (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t  var elemtsearchId_in = elemtsearchId_in.querySelectorAll('.'+elems[item].classList[4])[0]\n\t\t  var x = elemtsearchId_in.offsetWidth/2 + (elemtsearchId_in.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t  var y = elemtsearchId_in.offsetHeight/2 + (elemtsearchId_in.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t  const lineCurve = createCurvature(line_x, line_y, x, y, curvature, 'openclose');\n\t\t  elems[item].children[0].setAttributeNS(null, 'd', lineCurve );\n  \n\t\t} else {\n\t\t  const points = elems[item].querySelectorAll('.point');\n\t\t  let linecurve = '';\n\t\t  const reoute_fix = [];\n\t\t  points.forEach((item, i) => {\n\t\t\tif(i === 0 && ((points.length -1) === 0)) {\n  \n\t\t\t  var elemtsearchId_out = container.querySelector(`#${id}`);\n\t\t\t  var elemtsearch = item;\n  \n\t\t\t  var line_x = (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var line_y = (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom +rerouteWidth;\n  \n\t\t\t  var elemtsearchIn = elemtsearchId_out.querySelectorAll('.'+item.parentElement.classList[4])[0]\n\t\t\t  var eX =  elemtsearchIn.offsetWidth/2 + (elemtsearchIn.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var eY =  elemtsearchIn.offsetHeight/2 + (elemtsearchIn.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'close');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t  var elemtsearchId_out = item;\n\t\t\t  var id_search = item.parentElement.classList[2].replace('node_out_', '');\n\t\t\t  var elemtsearchId = container.querySelector(`#${id_search}`);\n\t\t\t  var elemtsearch = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[3])[0]\n  \n\t\t\t  var elemtsearchOut = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[3])[0]\n\t\t\t  var line_x =  elemtsearchOut.offsetWidth/2 + (elemtsearchOut.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var line_y =  elemtsearchOut.offsetHeight/2 + (elemtsearchOut.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t\t  var eX = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var eY = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'open');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n  \n\t\t\t} else if(i === 0) {\n\t\t\t  // FIRST\n\t\t\t  var elemtsearchId_out = item;\n\t\t\t  var id_search = item.parentElement.classList[2].replace('node_out_', '');\n\t\t\t  var elemtsearchId = container.querySelector(`#${id_search}`);\n\t\t\t  var elemtsearch = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[3])[0]\n\t\t\t  var elemtsearchOut = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[3])[0]\n\t\t\t  var line_x =  elemtsearchOut.offsetWidth/2 + (elemtsearchOut.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var line_y =  elemtsearchOut.offsetHeight/2 + (elemtsearchOut.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t\t  var eX = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var eY = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'open');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t  // SECOND\n\t\t\t  var elemtsearchId_out = item;\n\t\t\t  var elemtsearch = points[i+1];\n  \n\t\t\t  var eX = (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var eY = (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom +rerouteWidth;\n\t\t\t  var line_x = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var line_y = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature, 'other');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t} else if (i === (points.length -1)) {\n  \n\t\t\t  var elemtsearchId_out = item;\n  \n\t\t\t  var id_search = item.parentElement.classList[1].replace('node_in_', '');\n\t\t\t  var elemtsearchId = container.querySelector(`#${id_search}`);\n\t\t\t  var elemtsearch = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[4])[0]\n  \n\t\t\t  var elemtsearchIn = elemtsearchId.querySelectorAll('.'+item.parentElement.classList[4])[0]\n\t\t\t  var eX =  elemtsearchIn.offsetWidth/2 + (elemtsearchIn.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom;\n\t\t\t  var eY =  elemtsearchIn.offsetHeight/2 + (elemtsearchIn.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom;\n  \n\t\t\t  var line_x = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var line_y = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature_start_end, 'close');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n  \n\t\t\t} else {\n  \n\t\t\t  var elemtsearchId_out = item;\n\t\t\t  var elemtsearch = points[i+1];\n  \n\t\t\t  var eX = (elemtsearch.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var eY = (elemtsearch.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom +rerouteWidth;\n\t\t\t  var line_x = (elemtsearchId_out.getBoundingClientRect().x - precanvas.getBoundingClientRect().x ) * precanvasWitdhZoom + rerouteWidth;\n\t\t\t  var line_y = (elemtsearchId_out.getBoundingClientRect().y - precanvas.getBoundingClientRect().y ) * precanvasHeightZoom + rerouteWidth;\n\t\t\t  var x = eX;\n\t\t\t  var y = eY;\n  \n\t\t\t  var lineCurveSearch = createCurvature(line_x, line_y, x, y, reroute_curvature, 'other');\n\t\t\t  linecurve += lineCurveSearch;\n\t\t\t  reoute_fix.push(lineCurveSearch);\n\t\t\t}\n  \n\t\t  });\n\t\t  if(reroute_fix_curvature) {\n\t\t\treoute_fix.forEach((itempath, i) => {\n\t\t\t  elems[item].children[i].setAttributeNS(null, 'd', itempath);\n\t\t\t});\n  \n\t\t  } else {\n\t\t\telems[item].children[0].setAttributeNS(null, 'd', linecurve);\n\t\t  }\n  \n\t\t}\n\t  })\n\t}\n  \n\tdblclick(e) {\n\t  if(this.connection_selected != null && this.reroute) {\n\t\t  this.createReroutePoint(this.connection_selected);\n\t  }\n  \n\t  if(e.target.classList[0] === 'point') {\n\t\t  this.removeReroutePoint(e.target);\n\t  }\n\t}\n  \n\tcreateReroutePoint(ele) {\n\t\tthis.connection_selected.classList.remove(\"selected\");\n\t\tconst nodeUpdate = this.connection_selected.parentElement.classList[2].slice(9);\n\t\tconst nodeUpdateIn = this.connection_selected.parentElement.classList[1].slice(13);\n\t\tconst output_class = this.connection_selected.parentElement.classList[3];\n\t\tconst input_class = this.connection_selected.parentElement.classList[4];\n\t\tthis.connection_selected = null;\n\t\tconst point = document.createElementNS('http://www.w3.org/2000/svg',\"circle\");\n\t\tpoint.classList.add(\"point\");\n\t\tvar pos_x = this.pos_x * ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)) - (this.precanvas.getBoundingClientRect().x * ( this.precanvas.clientWidth / (this.precanvas.clientWidth * this.zoom)));\n\t\tvar pos_y = this.pos_y * ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)) - (this.precanvas.getBoundingClientRect().y * ( this.precanvas.clientHeight / (this.precanvas.clientHeight * this.zoom)));\n  \n\t\tpoint.setAttributeNS(null, 'cx', pos_x);\n\t\tpoint.setAttributeNS(null, 'cy', pos_y);\n\t\tpoint.setAttributeNS(null, 'r', this.reroute_width);\n  \n\t\tlet position_add_array_point = 0;\n\t\tif(this.reroute_fix_curvature) {\n  \n\t\t  const numberPoints = ele.parentElement.querySelectorAll(\".main-path\").length;\n\t\t  var path = document.createElementNS('http://www.w3.org/2000/svg',\"path\");\n\t\t  path.classList.add(\"main-path\");\n\t\t  path.setAttributeNS(null, 'd', '');\n  \n\t\t  ele.parentElement.insertBefore(path, ele.parentElement.children[numberPoints]);\n\t\t  if(numberPoints === 1) {\n\t\t\tele.parentElement.appendChild(point);\n\t\t  }  else {\n\t\t\tconst search_point = Array.from(ele.parentElement.children).indexOf(ele)\n\t\t\tposition_add_array_point = search_point;\n\t\t\tele.parentElement.insertBefore(point, ele.parentElement.children[search_point+numberPoints+1]);\n\t\t  }\n  \n\t\t} else {\n\t\t  ele.parentElement.appendChild(point);\n\t\t}\n  \n\t\tconst nodeId = nodeUpdate.slice(5);\n\t\tconst searchConnection = this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections.findIndex(function(item,i) {\n\t\t  return item.node ===  nodeUpdateIn && item.output === input_class;\n\t\t});\n  \n\t\tif(this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points === undefined)  {\n\t\t  this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points = [];\n\t\t}\n  \n\t\tif(this.reroute_fix_curvature) {\n  \n\t\t  if(position_add_array_point > 0 || this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points !== []) {\n\t\t\tthis.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points.splice(position_add_array_point, 0, { pos_x: pos_x, pos_y: pos_y });\n\t\t  } else {\n\t\t\tthis.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points.push({ pos_x: pos_x, pos_y: pos_y });\n\t\t  }\n  \n\t\t  ele.parentElement.querySelectorAll(\".main-path\").forEach((item, i) => {\n\t\t\titem.classList.remove(\"selected\");\n\t\t  });\n  \n\t\t} else {\n\t\t  this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points.push({ pos_x: pos_x, pos_y: pos_y });\n\t\t}\n  \n\t\tthis.dispatch('addReroute', nodeId);\n\t\tthis.updateConnectionNodes(nodeUpdate);\n\t}\n  \n\tremoveReroutePoint(ele) {\n\t  const nodeUpdate = ele.parentElement.classList[2].slice(9)\n\t  const nodeUpdateIn = ele.parentElement.classList[1].slice(13);\n\t  const output_class = ele.parentElement.classList[3];\n\t  const input_class = ele.parentElement.classList[4];\n  \n\t  let numberPointPosition = Array.from(ele.parentElement.children).indexOf(ele);\n\t  const nodeId = nodeUpdate.slice(5);\n\t  const searchConnection = this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections.findIndex(function(item,i) {\n\t\treturn item.node ===  nodeUpdateIn && item.output === input_class;\n\t  });\n  \n\t  if(this.reroute_fix_curvature) {\n\t\t const numberMainPath = ele.parentElement.querySelectorAll(\".main-path\").length\n\t\t ele.parentElement.children[numberMainPath-1].remove();\n\t\t numberPointPosition -= numberMainPath;\n\t\t if(numberPointPosition < 0) {\n\t\t   numberPointPosition = 0;\n\t\t }\n\t  } else {\n\t\tnumberPointPosition--;\n\t  }\n\t  this.drawflow.drawflow[this.module].data[nodeId].outputs[output_class].connections[searchConnection].points.splice(numberPointPosition,1);\n  \n\t  ele.remove();\n\t  this.dispatch('removeReroute', nodeId);\n\t  this.updateConnectionNodes(nodeUpdate);\n\t}\n  \n\tregisterNode(name, html, props = null, options = null) {\n\t  this.noderegister[name] = {html: html, props: props, options: options};\n\t}\n  \n\tgetNodeFromId(id) {\n\t  var moduleName = this.getModuleFromNodeId(id)\n\t  return JSON.parse(JSON.stringify(this.drawflow.drawflow[moduleName].data[id]));\n\t}\n\tgetNodesFromName(name) {\n\t  var nodes = [];\n\t  const editor = this.drawflow.drawflow\n\t  Object.keys(editor).map(function(moduleName, index) {\n\t\tfor (var node in editor[moduleName].data) {\n\t\t  if(editor[moduleName].data[node].name == name) {\n\t\t\tnodes.push(editor[moduleName].data[node].id);\n\t\t  }\n\t\t}\n\t  });\n\t  return nodes;\n\t}\n  \n\taddNode (name, num_in, num_out, ele_pos_x, ele_pos_y, classoverride, data, html, typenode = false) {\n\t  if (this.useuuid) {\n\t\tvar newNodeId = this.getUuid();\n\t  } else {\n\t\tvar newNodeId = this.nodeId;\n\t  }\n\t  const parent = document.createElement('div');\n\t  parent.classList.add(\"parent-node\");\n  \n\t  const node = document.createElement('div');\n\t  node.innerHTML = \"\";\n\t  node.setAttribute(\"id\", \"node-\"+newNodeId);\n\t  node.classList.add(\"drawflow-node\");\n\t  if(classoverride != '') {\n\t\tnode.classList.add(...classoverride.split(' '));\n\t  }\n  \n\t  const inputs = document.createElement('div');\n\t  inputs.classList.add(\"inputs\");\n  \n\t  const outputs = document.createElement('div');\n\t  outputs.classList.add(\"outputs\");\n  \n\t  const json_inputs = {}\n\t  for(var x = 0; x < num_in; x++) {\n\t\tconst input = document.createElement('div');\n\t\tinput.classList.add(\"input\");\n\t\tinput.classList.add(\"input_\"+(x+1));\n\t\tjson_inputs[\"input_\"+(x+1)] = { \"connections\": []};\n\t\tinputs.appendChild(input);\n\t  }\n  \n\t  const json_outputs = {}\n\t  for(var x = 0; x < num_out; x++) {\n\t\tconst output = document.createElement('div');\n\t\toutput.classList.add(\"output\");\n\t\toutput.classList.add(\"output_\"+(x+1));\n\t\tjson_outputs[\"output_\"+(x+1)] = { \"connections\": []};\n\t\toutputs.appendChild(output);\n\t  }\n  \n\t  const content = document.createElement('div');\n\t  content.classList.add(\"drawflow_content_node\");\n\t  if(typenode === false) {\n\t\tcontent.innerHTML = html;\n\t  } else if (typenode === true) {\n\t\tcontent.appendChild(this.noderegister[html].html.cloneNode(true));\n\t  } else {\n\t\tif(parseInt(this.render.version) === 3 ) {\n\t\t  //Vue 3\n\t\t  let wrapper = this.render.h(this.noderegister[html].html, this.noderegister[html].props, this.noderegister[html].options);\n\t\t  wrapper.appContext = this.parent;\n\t\t  this.render.render(wrapper,content);\n  \n\t\t} else {\n\t\t  // Vue 2\n\t\t  let wrapper = new this.render({\n\t\t\tparent: this.parent,\n\t\t\trender: h => h(this.noderegister[html].html, { props: this.noderegister[html].props }),\n\t\t\t...this.noderegister[html].options\n\t\t  }).$mount()\n\t\t  //\n\t\t  content.appendChild(wrapper.$el);\n\t\t}\n\t  }\n  \n\t  Object.entries(data).forEach(function (key, value) {\n\t\tif(typeof key[1] === \"object\") {\n\t\t  insertObjectkeys(null, key[0], key[0]);\n\t\t} else {\n\t\t  var elems = content.querySelectorAll('[df-'+key[0]+']');\n\t\t\tfor(var i = 0; i < elems.length; i++) {\n\t\t\t  elems[i].value = key[1];\n\t\t\t  if(elems[i].isContentEditable) {\n\t\t\t\telems[i].innerText = key[1];\n\t\t\t  }\n\t\t\t}\n\t\t}\n\t  })\n  \n\t  function insertObjectkeys(object, name, completname) {\n\t\tif(object === null) {\n\t\t  var object = data[name];\n\t\t} else {\n\t\t  var object = object[name]\n\t\t}\n\t\tif(object !== null) {\n\t\t  Object.entries(object).forEach(function (key, value) {\n\t\t\tif(typeof key[1] === \"object\") {\n\t\t\t  insertObjectkeys(object, key[0], completname+'-'+key[0]);\n\t\t\t} else {\n\t\t\t  var elems = content.querySelectorAll('[df-'+completname+'-'+key[0]+']');\n\t\t\t\tfor(var i = 0; i < elems.length; i++) {\n\t\t\t\t  elems[i].value = key[1];\n\t\t\t\t  if(elems[i].isContentEditable) {\n\t\t\t\t\telems[i].innerText = key[1];\n\t\t\t\t  }\n\t\t\t\t}\n\t\t\t}\n\t\t  });\n\t\t}\n\t  }\n\t  node.appendChild(inputs);\n\t  node.appendChild(content);\n\t  node.appendChild(outputs);\n\t  node.style.top = ele_pos_y + \"px\";\n\t  node.style.left = ele_pos_x + \"px\";\n\t  parent.appendChild(node);\n\t  this.precanvas.appendChild(parent);\n\t  var json = {\n\t\tid: newNodeId,\n\t\tname: name,\n\t\tdata: data,\n\t\tclass: classoverride,\n\t\thtml: html,\n\t\ttypenode: typenode,\n\t\tinputs: json_inputs,\n\t\toutputs: json_outputs,\n\t\tpos_x: ele_pos_x,\n\t\tpos_y: ele_pos_y,\n\t  }\n\t  this.drawflow.drawflow[this.module].data[newNodeId] = json;\n\t  this.dispatch('nodeCreated', newNodeId);\n\t  if (!this.useuuid) {\n\t\tthis.nodeId++;\n\t  }\n\t  return newNodeId;\n\t}\n  \n\taddNodeImport (dataNode, precanvas) {\n\t  const parent = document.createElement('div');\n\t  parent.classList.add(\"parent-node\");\n  \n\t  const node = document.createElement('div');\n\t  node.innerHTML = \"\";\n\t  node.setAttribute(\"id\", \"node-\"+dataNode.id);\n\t  node.classList.add(\"drawflow-node\");\n\t  if(dataNode.class != '') {\n\t\tnode.classList.add(...dataNode.class.split(' '));\n\t  }\n  \n\t  const inputs = document.createElement('div');\n\t  inputs.classList.add(\"inputs\");\n  \n\t  const outputs = document.createElement('div');\n\t  outputs.classList.add(\"outputs\");\n  \n\t  Object.keys(dataNode.inputs).map(function(input_item, index) {\n\t\tconst input = document.createElement('div');\n\t\tinput.classList.add(\"input\");\n\t\tinput.classList.add(input_item);\n\t\tinputs.appendChild(input);\n\t\tObject.keys(dataNode.inputs[input_item].connections).map(function(output_item, index) {\n  \n\t\t  var connection = document.createElementNS('http://www.w3.org/2000/svg',\"svg\");\n\t\t  var path = document.createElementNS('http://www.w3.org/2000/svg',\"path\");\n\t\t  path.classList.add(\"main-path\");\n\t\t  path.setAttributeNS(null, 'd', '');\n\t\t  // path.innerHTML = 'a';\n\t\t  connection.classList.add(\"connection\");\n\t\t  connection.classList.add(\"node_in_node-\"+dataNode.id);\n\t\t  connection.classList.add(\"node_out_node-\"+dataNode.inputs[input_item].connections[output_item].node);\n\t\t  connection.classList.add(dataNode.inputs[input_item].connections[output_item].input);\n\t\t  connection.classList.add(input_item);\n  \n\t\t  connection.appendChild(path);\n\t\t  precanvas.appendChild(connection);\n  \n\t\t});\n\t  });\n  \n\t  for(var x = 0; x < Object.keys(dataNode.outputs).length; x++) {\n\t\tconst output = document.createElement('div');\n\t\toutput.classList.add(\"output\");\n\t\toutput.classList.add(\"output_\"+(x+1));\n\t\toutputs.appendChild(output);\n\t  }\n  \n\t  const content = document.createElement('div');\n\t  content.classList.add(\"drawflow_content_node\");\n  \n\t  if(dataNode.typenode === false) {\n\t\tcontent.innerHTML = dataNode.html;\n\t  } else if (dataNode.typenode === true) {\n\t\tcontent.appendChild(this.noderegister[dataNode.html].html.cloneNode(true));\n\t  } else {\n\t\tif(parseInt(this.render.version) === 3 ) {\n\t\t  //Vue 3\n\t\t  let wrapper = this.render.h(this.noderegister[dataNode.html].html, this.noderegister[dataNode.html].props, this.noderegister[dataNode.html].options);\n\t\t  wrapper.appContext = this.parent;\n\t\t  this.render.render(wrapper,content);\n  \n\t\t} else {\n\t\t  //Vue 2\n\t\t  let wrapper = new this.render({\n\t\t\tparent: this.parent,\n\t\t\trender: h => h(this.noderegister[dataNode.html].html, { props: this.noderegister[dataNode.html].props }),\n\t\t\t...this.noderegister[dataNode.html].options\n\t\t  }).$mount()\n\t\t  content.appendChild(wrapper.$el);\n\t\t}\n\t  }\n  \n\t  Object.entries(dataNode.data).forEach(function (key, value) {\n\t\tif(typeof key[1] === \"object\") {\n\t\t  insertObjectkeys(null, key[0], key[0]);\n\t\t} else {\n\t\t  var elems = content.querySelectorAll('[df-'+key[0]+']');\n\t\t\tfor(var i = 0; i < elems.length; i++) {\n\t\t\t  elems[i].value = key[1];\n\t\t\t  if(elems[i].isContentEditable) {\n\t\t\t\telems[i].innerText = key[1];\n\t\t\t  }\n\t\t\t}\n\t\t}\n\t  })\n  \n\t  function insertObjectkeys(object, name, completname) {\n\t\tif(object === null) {\n\t\t  var object = dataNode.data[name];\n\t\t} else {\n\t\t  var object = object[name]\n\t\t}\n\t\tif(object !== null) {\n\t\t  Object.entries(object).forEach(function (key, value) {\n\t\t\tif(typeof key[1] === \"object\") {\n\t\t\t  insertObjectkeys(object, key[0], completname+'-'+key[0]);\n\t\t\t} else {\n\t\t\t  var elems = content.querySelectorAll('[df-'+completname+'-'+key[0]+']');\n\t\t\t\tfor(var i = 0; i < elems.length; i++) {\n\t\t\t\t  elems[i].value = key[1];\n\t\t\t\t  if(elems[i].isContentEditable) {\n\t\t\t\t\telems[i].innerText = key[1];\n\t\t\t\t  }\n\t\t\t\t}\n\t\t\t}\n\t\t  });\n\t\t}\n\t  }\n\t  node.appendChild(inputs);\n\t  node.appendChild(content);\n\t  node.appendChild(outputs);\n\t  node.style.top = dataNode.pos_y + \"px\";\n\t  node.style.left = dataNode.pos_x + \"px\";\n\t  parent.appendChild(node);\n\t  this.precanvas.appendChild(parent);\n\t}\n  \n\taddRerouteImport(dataNode) {\n\t  const reroute_width = this.reroute_width\n\t  const reroute_fix_curvature = this.reroute_fix_curvature\n\t  const container = this.container;\n\t  Object.keys(dataNode.outputs).map(function(output_item, index) {\n\t\tObject.keys(dataNode.outputs[output_item].connections).map(function(input_item, index) {\n\t\t  const points = dataNode.outputs[output_item].connections[input_item].points\n\t\t  if(points !== undefined) {\n  \n\t\t\tpoints.forEach((item, i) => {\n\t\t\t  const input_id = dataNode.outputs[output_item].connections[input_item].node;\n\t\t\t  const input_class = dataNode.outputs[output_item].connections[input_item].output;\n\t\t\t  const ele = container.querySelector('.connection.node_in_node-'+input_id+'.node_out_node-'+dataNode.id+'.'+output_item+'.'+input_class);\n  \n\t\t\t  if(reroute_fix_curvature) {\n\t\t\t\tif(i === 0) {\n\t\t\t\t  for (var z = 0; z < points.length; z++) {\n\t\t\t\t\tvar path = document.createElementNS('http://www.w3.org/2000/svg',\"path\");\n\t\t\t\t\tpath.classList.add(\"main-path\");\n\t\t\t\t\tpath.setAttributeNS(null, 'd', '');\n\t\t\t\t\tele.appendChild(path);\n  \n\t\t\t\t  }\n\t\t\t\t}\n\t\t\t  }\n  \n\t\t\t  const point = document.createElementNS('http://www.w3.org/2000/svg',\"circle\");\n\t\t\t  point.classList.add(\"point\");\n\t\t\t  var pos_x = item.pos_x;\n\t\t\t  var pos_y = item.pos_y;\n  \n\t\t\t  point.setAttributeNS(null, 'cx', pos_x);\n\t\t\t  point.setAttributeNS(null, 'cy', pos_y);\n\t\t\t  point.setAttributeNS(null, 'r', reroute_width);\n  \n\t\t\t  ele.appendChild(point);\n\t\t\t});\n\t\t  };\n\t\t});\n\t  });\n\t}\n  \n\tupdateNodeValue(event) {\n\t  var attr = event.target.attributes\n\t  for (var i = 0; i < attr.length; i++) {\n\t\t\t  if (attr[i].nodeName.startsWith('df-')) {\n\t\t\t\t  var keys = attr[i].nodeName.slice(3).split(\"-\");\n\t\t\t\t  var target = this.drawflow.drawflow[this.module].data[event.target.closest(\".drawflow_content_node\").parentElement.id.slice(5)].data;\n\t\t\t\t  for (var index = 0; index < keys.length - 1; index += 1) {\n\t\t\t\t\t  if (target[keys[index]] == null) {\n\t\t\t\t\t\t  target[keys[index]] = {};\n\t\t\t\t\t  }\n\t\t\t\t\t  target = target[keys[index]];\n\t\t\t\t  }\n\t\t\t\t  target[keys[keys.length - 1]] = event.target.value;\n\t\t\t\t  if(event.target.isContentEditable) {\n\t\t\t\t\ttarget[keys[keys.length - 1]] = event.target.innerText;\n\t\t\t\t  }\n\t\t\t\t  this.dispatch('nodeDataChanged', event.target.closest(\".drawflow_content_node\").parentElement.id.slice(5));\n\t\t\t}\n\t  }\n\t}\n  \n\tupdateNodeDataFromId(id, data) {\n\t  var moduleName = this.getModuleFromNodeId(id)\n\t  this.drawflow.drawflow[moduleName].data[id].data = data;\n\t  if(this.module === moduleName) {\n\t\tconst content = this.container.querySelector('#node-'+id);\n  \n\t\tObject.entries(data).forEach(function (key, value) {\n\t\t  if(typeof key[1] === \"object\") {\n\t\t\tinsertObjectkeys(null, key[0], key[0]);\n\t\t  } else {\n\t\t\tvar elems = content.querySelectorAll('[df-'+key[0]+']');\n\t\t\t  for(var i = 0; i < elems.length; i++) {\n\t\t\t\telems[i].value = key[1];\n\t\t\t\tif(elems[i].isContentEditable) {\n\t\t\t\t  elems[i].innerText = key[1];\n\t\t\t\t}\n\t\t\t  }\n\t\t  }\n\t\t})\n  \n\t\tfunction insertObjectkeys(object, name, completname) {\n\t\t  if(object === null) {\n\t\t\tvar object = data[name];\n\t\t  } else {\n\t\t\tvar object = object[name]\n\t\t  }\n\t\t  if(object !== null) {\n\t\t\tObject.entries(object).forEach(function (key, value) {\n\t\t\t  if(typeof key[1] === \"object\") {\n\t\t\t\tinsertObjectkeys(object, key[0], completname+'-'+key[0]);\n\t\t\t  } else {\n\t\t\t\tvar elems = content.querySelectorAll('[df-'+completname+'-'+key[0]+']');\n\t\t\t\t  for(var i = 0; i < elems.length; i++) {\n\t\t\t\t\telems[i].value = key[1];\n\t\t\t\t\tif(elems[i].isContentEditable) {\n\t\t\t\t\t  elems[i].innerText = key[1];\n\t\t\t\t\t}\n\t\t\t\t  }\n\t\t\t  }\n\t\t\t});\n\t\t  }\n\t\t}\n  \n\t  }\n\t}\n  \n\taddNodeInput(id) {\n\t  var moduleName = this.getModuleFromNodeId(id)\n\t  const infoNode = this.getNodeFromId(id)\n\t  const numInputs = Object.keys(infoNode.inputs).length;\n\t  if(this.module === moduleName) {\n\t\t//Draw input\n\t\tconst input = document.createElement('div');\n\t\tinput.classList.add(\"input\");\n\t\tinput.classList.add(\"input_\"+(numInputs+1));\n\t\tconst parent = this.container.querySelector('#node-'+id+' .inputs');\n\t\tparent.appendChild(input);\n\t\tthis.updateConnectionNodes('node-'+id);\n  \n\t  }\n\t  this.drawflow.drawflow[moduleName].data[id].inputs[\"input_\"+(numInputs+1)] = { \"connections\": []};\n\t}\n  \n\taddNodeOutput(id) {\n\t  var moduleName = this.getModuleFromNodeId(id)\n\t  const infoNode = this.getNodeFromId(id)\n\t  const numOutputs = Object.keys(infoNode.outputs).length;\n\t  if(this.module === moduleName) {\n\t\t//Draw output\n\t\tconst output = document.createElement('div');\n\t\toutput.classList.add(\"output\");\n\t\toutput.classList.add(\"output_\"+(numOutputs+1));\n\t\tconst parent = this.container.querySelector('#node-'+id+' .outputs');\n\t\tparent.appendChild(output);\n\t\tthis.updateConnectionNodes('node-'+id);\n  \n\t  }\n\t  this.drawflow.drawflow[moduleName].data[id].outputs[\"output_\"+(numOutputs+1)] = { \"connections\": []};\n\t}\n  \n\tremoveNodeInput(id, input_class) {\n\t  var moduleName = this.getModuleFromNodeId(id)\n\t  const infoNode = this.getNodeFromId(id)\n\t  if(this.module === moduleName) {\n\t\tthis.container.querySelector('#node-'+id+' .inputs .input.'+input_class).remove();\n\t  }\n\t  const removeInputs = [];\n\t  Object.keys(infoNode.inputs[input_class].connections).map(function(key, index) {\n\t\tconst id_output = infoNode.inputs[input_class].connections[index].node;\n\t\tconst output_class = infoNode.inputs[input_class].connections[index].input;\n\t\tremoveInputs.push({id_output, id, output_class, input_class})\n\t  })\n\t  // Remove connections\n\t  removeInputs.forEach((item, i) => {\n\t\tthis.removeSingleConnection(item.id_output, item.id, item.output_class, item.input_class);\n\t  });\n  \n\t  delete this.drawflow.drawflow[moduleName].data[id].inputs[input_class];\n  \n\t  // Update connection\n\t  const connections = [];\n\t  const connectionsInputs = this.drawflow.drawflow[moduleName].data[id].inputs\n\t  Object.keys(connectionsInputs).map(function(key, index) {\n\t\tconnections.push(connectionsInputs[key]);\n\t  });\n\t  this.drawflow.drawflow[moduleName].data[id].inputs = {};\n\t  const input_class_id = input_class.slice(6);\n\t  let nodeUpdates = [];\n\t  connections.forEach((item, i) => {\n\t\titem.connections.forEach((itemx, f) => {\n\t\t  nodeUpdates.push(itemx);\n\t\t});\n\t\tthis.drawflow.drawflow[moduleName].data[id].inputs['input_'+ (i+1)] = item;\n\t  });\n\t  nodeUpdates =  new Set(nodeUpdates.map(e => JSON.stringify(e)));\n\t  nodeUpdates = Array.from(nodeUpdates).map(e => JSON.parse(e));\n  \n\t  if(this.module === moduleName) {\n\t\tconst eles = this.container.querySelectorAll(\"#node-\"+id +\" .inputs .input\");\n\t\teles.forEach((item, i) => {\n\t\t  const id_class = item.classList[1].slice(6);\n\t\t  if(parseInt(input_class_id) < parseInt(id_class)) {\n\t\t\titem.classList.remove('input_'+id_class);\n\t\t\titem.classList.add('input_'+(id_class-1));\n\t\t  }\n\t\t});\n  \n\t  }\n  \n\t  nodeUpdates.forEach((itemx, i) => {\n\t\tthis.drawflow.drawflow[moduleName].data[itemx.node].outputs[itemx.input].connections.forEach((itemz, g) => {\n\t\t\tif(itemz.node == id) {\n\t\t\t  const output_id = itemz.output.slice(6);\n\t\t\t  if(parseInt(input_class_id) < parseInt(output_id)) {\n\t\t\t\tif(this.module === moduleName) {\n\t\t\t\t  const ele = this.container.querySelector(\".connection.node_in_node-\"+id+\".node_out_node-\"+itemx.node+\".\"+itemx.input+\".input_\"+output_id);\n\t\t\t\t  ele.classList.remove('input_'+output_id);\n\t\t\t\t  ele.classList.add('input_'+(output_id-1));\n\t\t\t\t}\n\t\t\t\tif(itemz.points) {\n\t\t\t\t\tthis.drawflow.drawflow[moduleName].data[itemx.node].outputs[itemx.input].connections[g] = { node: itemz.node, output: 'input_'+(output_id-1), points: itemz.points }\n\t\t\t\t} else {\n\t\t\t\t\tthis.drawflow.drawflow[moduleName].data[itemx.node].outputs[itemx.input].connections[g] = { node: itemz.node, output: 'input_'+(output_id-1)}\n\t\t\t\t}\n\t\t\t  }\n\t\t\t}\n\t\t});\n\t  });\n\t  this.updateConnectionNodes('node-'+id);\n\t}\n  \n\tremoveNodeOutput(id, output_class) {\n\t  var moduleName = this.getModuleFromNodeId(id)\n\t  const infoNode = this.getNodeFromId(id)\n\t  if(this.module === moduleName) {\n\t\tthis.container.querySelector('#node-'+id+' .outputs .output.'+output_class).remove();\n\t  }\n\t  const removeOutputs = [];\n\t  Object.keys(infoNode.outputs[output_class].connections).map(function(key, index) {\n\t\tconst id_input = infoNode.outputs[output_class].connections[index].node;\n\t\tconst input_class = infoNode.outputs[output_class].connections[index].output;\n\t\tremoveOutputs.push({id, id_input, output_class, input_class})\n\t  })\n\t  // Remove connections\n\t  removeOutputs.forEach((item, i) => {\n\t\tthis.removeSingleConnection(item.id, item.id_input, item.output_class, item.input_class);\n\t  });\n  \n\t  delete this.drawflow.drawflow[moduleName].data[id].outputs[output_class];\n  \n\t  // Update connection\n\t  const connections = [];\n\t  const connectionsOuputs = this.drawflow.drawflow[moduleName].data[id].outputs\n\t  Object.keys(connectionsOuputs).map(function(key, index) {\n\t\tconnections.push(connectionsOuputs[key]);\n\t  });\n\t  this.drawflow.drawflow[moduleName].data[id].outputs = {};\n\t  const output_class_id = output_class.slice(7);\n\t  let nodeUpdates = [];\n\t  connections.forEach((item, i) => {\n\t\titem.connections.forEach((itemx, f) => {\n\t\t  nodeUpdates.push({ node: itemx.node, output: itemx.output });\n\t\t});\n\t\tthis.drawflow.drawflow[moduleName].data[id].outputs['output_'+ (i+1)] = item;\n\t  });\n\t  nodeUpdates =  new Set(nodeUpdates.map(e => JSON.stringify(e)));\n\t  nodeUpdates = Array.from(nodeUpdates).map(e => JSON.parse(e));\n  \n\t  if(this.module === moduleName) {\n\t\tconst eles = this.container.querySelectorAll(\"#node-\"+id +\" .outputs .output\");\n\t\teles.forEach((item, i) => {\n\t\t  const id_class = item.classList[1].slice(7);\n\t\t  if(parseInt(output_class_id) < parseInt(id_class)) {\n\t\t\titem.classList.remove('output_'+id_class);\n\t\t\titem.classList.add('output_'+(id_class-1));\n\t\t  }\n\t\t});\n  \n\t  }\n  \n\t  nodeUpdates.forEach((itemx, i) => {\n\t\tthis.drawflow.drawflow[moduleName].data[itemx.node].inputs[itemx.output].connections.forEach((itemz, g) => {\n\t\t\tif(itemz.node == id) {\n\t\t\t  const input_id = itemz.input.slice(7);\n\t\t\t  if(parseInt(output_class_id) < parseInt(input_id)) {\n\t\t\t\tif(this.module === moduleName) {\n  \n\t\t\t\t  const ele = this.container.querySelector(\".connection.node_in_node-\"+itemx.node+\".node_out_node-\"+id+\".output_\"+input_id+\".\"+itemx.output);\n\t\t\t\t  ele.classList.remove('output_'+input_id);\n\t\t\t\t  ele.classList.remove(itemx.output);\n\t\t\t\t  ele.classList.add('output_'+(input_id-1));\n\t\t\t\t  ele.classList.add(itemx.output);\n\t\t\t\t}\n\t\t\t\tif(itemz.points) {\n\t\t\t\t\tthis.drawflow.drawflow[moduleName].data[itemx.node].inputs[itemx.output].connections[g] = { node: itemz.node, input: 'output_'+(input_id-1), points: itemz.points }\n\t\t\t\t} else {\n\t\t\t\t\tthis.drawflow.drawflow[moduleName].data[itemx.node].inputs[itemx.output].connections[g] = { node: itemz.node, input: 'output_'+(input_id-1)}\n\t\t\t\t}\n\t\t\t  }\n\t\t\t}\n\t\t});\n\t  });\n  \n\t  this.updateConnectionNodes('node-'+id);\n\t}\n  \n\tremoveNodeId(id) {\n\t  this.removeConnectionNodeId(id);\n\t  var moduleName = this.getModuleFromNodeId(id.slice(5))\n\t  if(this.module === moduleName) {\n\t\tthis.container.querySelector(`#${id}`).remove();\n\t  }\n\t  delete this.drawflow.drawflow[moduleName].data[id.slice(5)];\n\t  this.dispatch('nodeRemoved', id.slice(5));\n\t}\n  \n\tremoveConnection() {\n\t  if(this.connection_selected != null) {\n\t\tvar listclass = this.connection_selected.parentElement.classList;\n\t\tthis.connection_selected.parentElement.remove();\n\t\t//console.log(listclass);\n\t\tvar index_out = this.drawflow.drawflow[this.module].data[listclass[2].slice(14)].outputs[listclass[3]].connections.findIndex(function(item,i) {\n\t\t  return item.node === listclass[1].slice(13) && item.output === listclass[4]\n\t\t});\n\t\tthis.drawflow.drawflow[this.module].data[listclass[2].slice(14)].outputs[listclass[3]].connections.splice(index_out,1);\n  \n\t\tvar index_in = this.drawflow.drawflow[this.module].data[listclass[1].slice(13)].inputs[listclass[4]].connections.findIndex(function(item,i) {\n\t\t  return item.node === listclass[2].slice(14) && item.input === listclass[3]\n\t\t});\n\t\tthis.drawflow.drawflow[this.module].data[listclass[1].slice(13)].inputs[listclass[4]].connections.splice(index_in,1);\n\t\tthis.dispatch('connectionRemoved', { output_id: listclass[2].slice(14), input_id: listclass[1].slice(13), output_class: listclass[3], input_class: listclass[4] } );\n\t\tthis.connection_selected = null;\n\t  }\n\t}\n  \n\tremoveSingleConnection(id_output, id_input, output_class, input_class) {\n\t  var nodeOneModule = this.getModuleFromNodeId(id_output);\n\t  var nodeTwoModule = this.getModuleFromNodeId(id_input);\n\t  if(nodeOneModule === nodeTwoModule) {\n\t\t// Check nodes in same module.\n  \n\t\t// Check connection exist\n\t\tvar exists = this.drawflow.drawflow[nodeOneModule].data[id_output].outputs[output_class].connections.findIndex(function(item,i) {\n\t\t  return item.node == id_input && item.output === input_class\n\t\t});\n\t\tif(exists > -1) {\n  \n\t\t  if(this.module === nodeOneModule) {\n\t\t\t// In same module with view.\n\t\t\tthis.container.querySelector('.connection.node_in_node-'+id_input+'.node_out_node-'+id_output+'.'+output_class+'.'+input_class).remove();\n\t\t  }\n  \n\t\t  var index_out = this.drawflow.drawflow[nodeOneModule].data[id_output].outputs[output_class].connections.findIndex(function(item,i) {\n\t\t\treturn item.node == id_input && item.output === input_class\n\t\t  });\n\t\t  this.drawflow.drawflow[nodeOneModule].data[id_output].outputs[output_class].connections.splice(index_out,1);\n  \n\t\t  var index_in = this.drawflow.drawflow[nodeOneModule].data[id_input].inputs[input_class].connections.findIndex(function(item,i) {\n\t\t\treturn item.node == id_output && item.input === output_class\n\t\t  });\n\t\t  this.drawflow.drawflow[nodeOneModule].data[id_input].inputs[input_class].connections.splice(index_in,1);\n  \n\t\t  this.dispatch('connectionRemoved', { output_id: id_output, input_id: id_input, output_class:  output_class, input_class: input_class});\n\t\t  return true;\n  \n\t\t} else {\n\t\t  return false;\n\t\t}\n\t  } else {\n\t\treturn false;\n\t  }\n\t}\n  \n\tremoveConnectionNodeId(id) {\n\t  const idSearchIn = 'node_in_'+id;\n\t  const idSearchOut = 'node_out_'+id;\n  \n\t  const elemsOut = this.container.querySelectorAll(`.${idSearchOut}`);\n\t  for(var i = elemsOut.length-1; i >= 0; i--) {\n\t\tvar listclass = elemsOut[i].classList;\n  \n\t\tvar index_in = this.drawflow.drawflow[this.module].data[listclass[1].slice(13)].inputs[listclass[4]].connections.findIndex(function(item,i) {\n\t\t  return item.node === listclass[2].slice(14) && item.input === listclass[3]\n\t\t});\n\t\tthis.drawflow.drawflow[this.module].data[listclass[1].slice(13)].inputs[listclass[4]].connections.splice(index_in,1);\n  \n\t\tvar index_out = this.drawflow.drawflow[this.module].data[listclass[2].slice(14)].outputs[listclass[3]].connections.findIndex(function(item,i) {\n\t\t  return item.node === listclass[1].slice(13) && item.output === listclass[4]\n\t\t});\n\t\tthis.drawflow.drawflow[this.module].data[listclass[2].slice(14)].outputs[listclass[3]].connections.splice(index_out,1);\n  \n\t\telemsOut[i].remove();\n  \n\t\tthis.dispatch('connectionRemoved', { output_id: listclass[2].slice(14), input_id: listclass[1].slice(13), output_class: listclass[3], input_class: listclass[4] } );\n\t  }\n  \n\t  const elemsIn = this.container.querySelectorAll(`.${idSearchIn}`);\n\t  for(var i = elemsIn.length-1; i >= 0; i--) {\n  \n\t\tvar listclass = elemsIn[i].classList;\n  \n\t\tvar index_out = this.drawflow.drawflow[this.module].data[listclass[2].slice(14)].outputs[listclass[3]].connections.findIndex(function(item,i) {\n\t\t  return item.node === listclass[1].slice(13) && item.output === listclass[4]\n\t\t});\n\t\tthis.drawflow.drawflow[this.module].data[listclass[2].slice(14)].outputs[listclass[3]].connections.splice(index_out,1);\n  \n\t\tvar index_in = this.drawflow.drawflow[this.module].data[listclass[1].slice(13)].inputs[listclass[4]].connections.findIndex(function(item,i) {\n\t\t  return item.node === listclass[2].slice(14) && item.input === listclass[3]\n\t\t});\n\t\tthis.drawflow.drawflow[this.module].data[listclass[1].slice(13)].inputs[listclass[4]].connections.splice(index_in,1);\n  \n\t\telemsIn[i].remove();\n  \n\t\tthis.dispatch('connectionRemoved', { output_id: listclass[2].slice(14), input_id: listclass[1].slice(13), output_class: listclass[3], input_class: listclass[4] } );\n\t  }\n\t}\n  \n\tgetModuleFromNodeId(id) {\n\t  var nameModule;\n\t  const editor = this.drawflow.drawflow\n\t  Object.keys(editor).map(function(moduleName, index) {\n\t\tObject.keys(editor[moduleName].data).map(function(node, index2) {\n\t\t  if(node == id) {\n\t\t\tnameModule = moduleName;\n\t\t  }\n\t\t})\n\t  });\n\t  return nameModule;\n\t}\n  \n\taddModule(name) {\n\t  this.drawflow.drawflow[name] =  { \"data\": {} };\n\t  this.dispatch('moduleCreated', name);\n\t}\n\tchangeModule(name) {\n\t  this.dispatch('moduleChanged', name);\n\t  this.module = name;\n\t  this.precanvas.innerHTML = \"\";\n\t  this.canvas_x = 0;\n\t  this.canvas_y = 0;\n\t  this.pos_x = 0;\n\t  this.pos_y = 0;\n\t  this.mouse_x = 0;\n\t  this.mouse_y = 0;\n\t  this.zoom = 1;\n\t  this.zoom_last_value = 1;\n\t  this.precanvas.style.transform = '';\n\t  this.import(this.drawflow, false);\n\t}\n  \n\tremoveModule(name) {\n\t  if(this.module === name) {\n\t\tthis.changeModule('Home');\n\t  }\n\t  delete this.drawflow.drawflow[name];\n\t  this.dispatch('moduleRemoved', name);\n\t}\n  \n\tclearModuleSelected() {\n\t  this.precanvas.innerHTML = \"\";\n\t  this.drawflow.drawflow[this.module] =  { \"data\": {} };\n\t}\n  \n\tclear () {\n\t  this.precanvas.innerHTML = \"\";\n\t  this.drawflow = { \"drawflow\": { \"Home\": { \"data\": {} }}};\n\t}\n\texport () {\n\t  const dataExport = JSON.parse(JSON.stringify(this.drawflow));\n\t  this.dispatch('export', dataExport);\n\t  return dataExport;\n\t}\n  \n\timport (data, notifi = true) {\n\t  this.clear();\n\t  this.drawflow = JSON.parse(JSON.stringify(data));\n\t  this.load();\n\t  if(notifi) {\n\t\tthis.dispatch('import', 'import');\n\t  }\n\t}\n  \n\t/* Events */\n\ton (event, callback) {\n\t\t // Check if the callback is not a function\n\t\t if (typeof callback !== 'function') {\n\t\t\t console.error(`The listener callback must be a function, the given type is ${typeof callback}`);\n\t\t\t return false;\n\t\t }\n\t\t // Check if the event is not a string\n\t\t if (typeof event !== 'string') {\n\t\t\t console.error(`The event name must be a string, the given type is ${typeof event}`);\n\t\t\t return false;\n\t\t }\n\t\t // Check if this event not exists\n\t\t if (this.events[event] === undefined) {\n\t\t\t this.events[event] = {\n\t\t\t\t listeners: []\n\t\t\t }\n\t\t }\n\t\t this.events[event].listeners.push(callback);\n\t }\n  \n\t removeListener (event, callback) {\n\t\t// Check if this event not exists\n  \n\t\tif (!this.events[event]) return false\n  \n\t\tconst listeners = this.events[event].listeners\n\t\tconst listenerIndex = listeners.indexOf(callback)\n\t\tconst hasListener = listenerIndex > -1\n\t\tif (hasListener) listeners.splice(listenerIndex, 1)\n\t }\n  \n\t dispatch (event, details) {\n\t\t // Check if this event not exists\n\t\t if (this.events[event] === undefined) {\n\t\t\t // console.error(`This event: ${event} does not exist`);\n\t\t\t return false;\n\t\t }\n\t\t this.events[event].listeners.forEach((listener) => {\n\t\t\t listener(details);\n\t\t });\n\t }\n  \n\t  getUuid() {\n\t\t  // http://www.ietf.org/rfc/rfc4122.txt\n\t\t  var s = [];\n\t\t  var hexDigits = \"0123456789abcdef\";\n\t\t  for (var i = 0; i < 36; i++) {\n\t\t\t  s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);\n\t\t  }\n\t\t  s[14] = \"4\";  // bits 12-15 of the time_hi_and_version field to 0010\n\t\t  s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01\n\t\t  s[8] = s[13] = s[18] = s[23] = \"-\";\n  \n\t\t  var uuid = s.join(\"\");\n\t\t  return uuid;\n\t  }\n  }\n  \n\n//# sourceURL=webpack://Drawflow/./assets_src/backend/js/multistep.js?");

/***/ })

/******/ })["default"];
});